// XISLCallTag.cpp: CXISLCallTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLCallTag.h"
#include "XISLDialogTag.h"
#include "XISLExchangeTag.h"
#include "XISLVar.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLCallTag::CXISLCallTag(int nType)
{
	m_nTagType = nType;
	if(m_nTagType == ID_TAG_CALL)
	{
		m_nBmpID = IDB_CALL;
		m_pReturnList = new CPtrList;
	}
	else if(m_nTagType == ID_TAG_GOTO)
	{
		m_nBmpID = IDB_GOTO;
		m_pReturnList = NULL;
	}

	m_pNextDialog = NULL;
	m_pParentTag = NULL;
}
/*
CXISLCallTag::CXISLCallTag(CXISLTag *pParent,CXISLDialogTag *pCallDialog,LPCTSTR lpszNameList,LPCTSTR lpszReturnList)
{
	m_pParentTag = pParent;
	m_nTagType = ID_TAG_CALL;
	m_nBmpID = IDB_CALL;

	m_pNextDialog = pCallDialog;
//	m_strNext = "";
//	m_strNameList = lpszNameList;
//	m_strReturn = lpszReturnList;
}
*/
CXISLCallTag::~CXISLCallTag()
{
	InitPtrList();
	if(m_pReturnList)
	{
		delete m_pReturnList;
		m_pReturnList = NULL;
	}
	if(m_pNextDialog)
		m_pNextDialog->RemoveReCallTag(this);
}

CXISLCallTag::CXISLCallTag(const CXISLCallTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_pNextDialog = cpXISL.m_pNextDialog;

	InitPtrList();
	m_NameList.RemoveAll();
	m_pReturnList->RemoveAll();
	POSITION pos = cpXISL.m_NameList.GetHeadPosition();
	while(pos)
		m_NameList.AddTail(cpXISL.m_NameList.GetNext(pos));
	pos = cpXISL.m_pReturnList->GetHeadPosition();
	while(pos)
		m_pReturnList->AddTail(cpXISL.m_pReturnList->GetNext(pos));
}

CXISLCallTag& CXISLCallTag::operator=(const CXISLCallTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		m_pNextDialog = cpXISL.m_pNextDialog;

		InitPtrList();
		m_NameList.RemoveAll();
		m_pReturnList->RemoveAll();
		POSITION pos = cpXISL.m_NameList.GetHeadPosition();
		while(pos)
			m_NameList.AddTail(cpXISL.m_NameList.GetNext(pos));
		pos = cpXISL.m_pReturnList->GetHeadPosition();
		while(pos)
			m_pReturnList->AddTail(cpXISL.m_pReturnList->GetNext(pos));
	}
	return *this;
}

LPCTSTR CXISLCallTag::GetXISLString()
{
	CString strTemp;
	CString strNext;
	if(m_pNextDialog)
	{
		strNext = m_pNextDialog->GetDocName();
		strNext += "#";
		strNext += m_pNextDialog->GetDialogID();
	}
	else
		strNext = "???";
	if(m_nTagType == ID_TAG_CALL)
	{
		m_strXISL = "<call next = \"";
		m_strXISL += strNext;
		if(!m_NameList.IsEmpty())
		{
			m_strXISL += "\" namelist = \"";
			GetNameList(strTemp);
			m_strXISL += strTemp;
		}
		if(!m_pReturnList->IsEmpty())
		{
			m_strXISL += "\" return = \"";
			strTemp.Empty();
			GetReturnList(strTemp);
			m_strXISL += strTemp;
		}
		m_strXISL += "\"/>\r\n";
	}
	else if(m_nTagType == ID_TAG_GOTO)
	{
		m_strXISL = "<goto next = \"";
		m_strXISL += strNext;
		if(!m_NameList.IsEmpty())
		{
			m_strXISL += "\" namelist = \"";
			GetNameList(strTemp);
			m_strXISL += strTemp;
		}
		m_strXISL += "\"/>\r\n";
	}
	else
		ASSERT(NULL);
	return m_strXISL;
}

//BOOL CXISLCallTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLCallTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[m_nTagType];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	return TRUE;
}

void CXISLCallTag::InitPtrList()
{
	POSITION oldPos = NULL;
	POSITION pos = m_NameList.GetHeadPosition();
	while(pos)
	{
		oldPos = pos;
		CXISLVar *pVar = (CXISLVar*)m_NameList.GetNext(pos);
		m_NameList.RemoveAt(oldPos);
		if(pVar->IsDummy())
			delete pVar;
	}
}

int CXISLCallTag::SetCallAttribute(CXISLDialogTag *pDTag,LPCTSTR lpszNameList,LPCTSTR lpszReturnList)
{
	m_pNextDialog = pDTag;
	//namelistreturn̉
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pParentTag->GetParentExcTag();
	CString strNameList = lpszNameList;
	CString strReturn = lpszReturnList;

	BOOL bFin = FALSE;
	int nIndex = 0;
	if(!strNameList.IsEmpty())
	{
		while(!bFin)
		{
			CString strVarName;
			nIndex = strNameList.Find(',');
			if(nIndex == -1)
			{
				strVarName = strNameList;
				bFin = TRUE;
			}
			else
				strVarName = strNameList.Left(nIndex);

			CXISLVar *pVar = NULL;
			if(strVarName[0] != '\'')
			{
				pVar = pExcItem->m_pLocalVar->FindVarWithParent(strVarName);
				if(pVar == NULL)
				{
					pVar = new CXISLVar;
					pVar->SetAttribute(strVarName,"",FALSE,FALSE);
					pExcItem->m_pLocalVar->RegistVar(pVar);
				}
				pVar->ReferCount(TRUE);
//				pVar->m_pParent->ReferVar(pVar->GetVarName(),TRUE);
			}
			else
			{
				strVarName.Delete(0);
				strVarName.Delete(strVarName.GetLength()-1);
				pVar = new CXISLVar;
				pVar->SetAttribute(strVarName,"",FALSE,TRUE);
			}
			m_NameList.AddTail(pVar);
			strNameList.Delete(0,nIndex+1);
		}
	}

	bFin = FALSE;
	if(!strReturn.IsEmpty())
	{
		while(!bFin)
		{
			CString strVarName;
			nIndex = strReturn.Find(',');
			if(nIndex == -1)
			{
				strVarName = strReturn;
				bFin = TRUE;
			}
			else
				strVarName = strReturn.Left(nIndex);

			CXISLVar *pVar = NULL;
			pVar = pExcItem->m_pLocalVar->FindVarWithParent(strVarName);
			if(pVar == NULL)
			{
				pVar = new CXISLVar;
				pVar->SetAttribute(strVarName,"",FALSE,FALSE);
				pExcItem->m_pLocalVar->RegistVar(pVar);
			}

			m_pReturnList->AddTail(pVar);
			pVar->ReferCount(TRUE);
//			pExcItem->m_pLocalVar->ReferVar(pVar->GetVarName(),TRUE);
			strReturn.Delete(0,nIndex+1);
		}
	}
	return 0;
}

void CXISLCallTag::GetNameList(CString &strName)
{
	POSITION pos = m_NameList.GetHeadPosition();
	CString strTemp;
	strName.Empty();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_NameList.GetNext(pos);
		pVar->GetVarNameEx(strTemp);
		strName += strTemp;
		strName += ",";
	}
	strName.Delete(strName.GetLength()-1);
}

void CXISLCallTag::GetReturnList(CString &strReturn)
{
	POSITION pos = m_pReturnList->GetHeadPosition();
	CString strTemp;
	strReturn.Empty();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_pReturnList->GetNext(pos);
		pVar->GetVarNameEx(strTemp);
		strReturn += strTemp;
		strReturn += ",";
	}
	strReturn.Delete(strReturn.GetLength()-1);
}

void CXISLCallTag::DeleteList()
{
	m_NameList.RemoveAll();
	if(m_nTagType==ID_TAG_CALL){
		m_pReturnList->RemoveAll();
		delete m_pReturnList;
		m_pReturnList=NULL;
	}
}